#include ".\pythoninclude\Python.h"
#include "scripts.h"
#include "engine.h"
#include "helper_functions.h"

PyObject* scriptsdll_createobject(PyObject *self, PyObject *args)
{
	float x,y,z;
	const char* preset;
	int id;

	if (!PyArg_ParseTuple(args, "sfff", &preset, &x, &y, &z))
	{
		printf("\nError occured inside scriptsdll.createobject.\n Bad argument(s)?\n");
		return NULL;
	}
	Vector3 pos = Vector3(x,y,z);

	id = Helper::Get_ID(Commands->Create_Object(preset, pos));
	return Py_BuildValue("i", id);
}

PyCFunction* scriptsdll_destroyobject(PyObject *self, PyObject *args)
{
	int id;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.destroyobject.\n Bad argument(s)?\n");
        return NULL;
	}
	Commands->Destroy_Object(Commands->Find_Object(id));
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyObject* scriptsdll_getpresetname(PyObject *self, PyObject *args)
{
	int id;
	const char* preset;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.getpresetname.\n Bad argument(s)?\n");
		return NULL;
	}

	preset = Commands->Get_Preset_Name(Commands->Find_Object(id));
	return Py_BuildValue("s", preset);
}

PyCFunction* scriptsdll_enablevehicletransitions(PyObject *self, PyObject *args)
{
	int id, enable;

	if (!PyArg_ParseTuple(args, "ii", &id, &enable))
	{
		printf("\nError occured inside scriptsdll.enablevehicletransitions.\n Bad argument(s)?\n");
        return NULL;
	}
	Commands->Enable_Vehicle_Transitions(Commands->Find_Object(id), enable);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_setmodel(PyObject *self, PyObject *args)
{
	int id;
	const char* model;

	if (!PyArg_ParseTuple(args, "is", &id, &model))
	{
		printf("\nError occured inside scriptsdll.setmodel.\n Bad argument(s)?\n");
        return NULL;
	}
	Commands->Set_Model(Commands->Find_Object(id), model);
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_gotolocation(PyObject *self, PyObject *args)
{
	int id, crouch;
	float x, y, z, speed, arrivedistance;

	if (!PyArg_ParseTuple(args, "ifffffi", &id, &x, &y, &z, &speed, &arrivedistance, &crouch))
	{
		printf("\nError occured inside scriptsdll.gotolocation.\n Bad argument(s)?\n");
        return NULL;
	}

	ActionParamsStruct aps;
	Vector3 pos = Vector3(x, y, z);

	aps.Set_Goto_Location(pos, speed, arrivedistance, crouch);
	Commands->Action_Goto(Commands->Find_Object(id), aps); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_gotoobject(PyObject *self, PyObject *args)
{
	int id, gotoid;
	float speed, arrivedistance;

	if (!PyArg_ParseTuple(args, "iiff", &id, &gotoid, &speed, &arrivedistance))
	{
		printf("\nError occured inside scriptsdll.gotoobject.\n Bad argument(s)?\n");
        return NULL;
	}

	ActionParamsStruct aps;

	aps.Set_Goto(Commands->Find_Object(gotoid), speed, arrivedistance);
	Commands->Action_Goto(Commands->Find_Object(id), aps); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_disablephysicalcollisions(PyObject *self, PyObject *args)
{
	int id;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.disablephysicalcollisions.\n Bad argument(s)?\n");
        return NULL;
	}


	Commands->Disable_Physical_Collisions(Commands->Find_Object(id)); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_enablecollisions(PyObject *self, PyObject *args)
{
	int id;

	if (!PyArg_ParseTuple(args, "i", &id))
	{
		printf("\nError occured inside scriptsdll.enablecollisions.\n Bad argument(s)?\n");
        return NULL;
	}


	Commands->Enable_Collisions(Commands->Find_Object(id)); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_create2dsoundplayer(PyObject *self, PyObject *args)
{
	int id;
	const char* soundname;

	if (!PyArg_ParseTuple(args, "is", &id, &soundname))
	{
		printf("\nError occured inside scriptsdll.Create_2D_Sound_Player().\n Bad argument(s)?\n");
        return NULL;
	}


	Create_2D_Sound_Player(Commands->Find_Object(id), soundname); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_create2dwavsoundplayer(PyObject *self, PyObject *args)
{
	int id;
	const char* soundname;

	if (!PyArg_ParseTuple(args, "is", &id, &soundname))
	{
		printf("\nError occured inside scriptsdll.Create_2D_WAV_Sound_Player().\n Bad argument(s)?\n");
        return NULL;
	}


	Create_2D_WAV_Sound_Player(Commands->Find_Object(id), soundname); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_create2dsoundteam(PyObject *self, PyObject *args)
{
	int team;
	const char* soundname;

	if (!PyArg_ParseTuple(args, "si", &soundname, &team))
	{
		printf("\nError occured inside scriptsdll.Create_2D_Sound_Team().\n Bad argument(s)?\n");
        return NULL;
	}


	Create_2D_Sound_Team(soundname, team); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}

PyCFunction* scriptsdll_create2dwavsoundteam(PyObject *self, PyObject *args)
{
	int team;
	const char* soundname;

	if (!PyArg_ParseTuple(args, "si", &soundname, &team))
	{
		printf("\nError occured inside scriptsdll.Create_2D_WAV_Sound_Team().\n Bad argument(s)?\n");
        return NULL;
	}


	Create_2D_WAV_Sound_Team(soundname, team); 
	Py_INCREF(Py_None);
	return (PyCFunction*)Py_None;
}